#region References

using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;
using System.Text;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

#endregion

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>David Askew</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>10/25/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Business object component providing functionality for
	///	transfusion reaction count report
	///</summary>

	#endregion

	public class TransfusionReactionReport : VbecsReport
	{
		#region Variables

		//private bool _detailedReport;
		//private bool _multiDivisionalReport;
        private DataSet _dsReport = new DataSet();

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/26/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6544"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6545"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// DetailedReport
		/// </summary>
		public bool DetailedReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.DetailedReport]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.DetailedReport] = value;
			}
		}

		#endregion

		#region Instance Methods

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7853"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7854"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate and print report
		/// Used by VbecsConsoleReport application
		/// </summary>
        protected override VbecsReportPrinter createReportPrinter()
		{
            BOL.VbecsUser user = new BOL.VbecsUser(this.PrintedBy);
            DataSet dsHeader = VbecsReport.GetReportHeader(user.UserName);
            DataSet dsFooter = VbecsReport.GetReportFooter(this.GetReportCriteria());
            //
            _dsReport = this.GetReportData();

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReport.Tables.Count > 0)
            {
                reportSourceMain.Name = "TransfusionReactionCountDataSet";
                reportSourceMain.Value = _dsReport.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionCount.TransfusionReactionCountReport.rdlc");
            Stream streamDetail = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionCount.TransfusionReactionCountDetails.rdlc");
            Stream streamSummary = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionCount.TransfusionReactionCountSummary.rdlc");

            LocalReport report = new LocalReport();
            report.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceFooter);
            report.DataSources.Add(reportSourceMain);
            report.LoadReportDefinition(stream);
            report.SetParameters(new ReportParameter("ReportTitle", "Transfusion Reaction Count Report"));

            if (this.DetailedReport)
            {
                report.LoadSubreportDefinition("TransfusionReactionCountDetails", streamDetail);
            }
            else
            {
                report.LoadSubreportDefinition("TransfusionReactionCountSummary", streamSummary);
            }
            return new BOL.VbecsReportPrinter(this.PrinterName, true, report);
        }

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "TransfusionReactionCountDetails" || e.DataSourceNames[0].ToString() == "TransfusionReactionCountDetailsDataSet")
            {
                ReportDataSource reportDetails = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportDetails.Name = "TransfusionReactionCountDetailsDataSet";
                    reportDetails.Value = _dsReport.Tables[1];
                }
                e.DataSources.Add(reportDetails);
            }
            else if (e.ReportPath == "TransfusionReactionCountSummary" || e.DataSourceNames[0].ToString() == "TransfusionReactionCountSummaryDataSet")
            {
                ReportDataSource reportSummary = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportSummary.Name = "TransfusionReactionCountSummaryDataSet";
                    reportSummary.Value = _dsReport.Tables[1];
                }
                e.DataSources.Add(reportSummary);
            }
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7855"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7856"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor
		/// </summary>
		public TransfusionReactionReport()
		{
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/25/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5861"> 
		///		<ExpectedInput>Valid business object data for summary report</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5862"> 
		///		<ExpectedInput>Valid business object data for multi divisional summary report</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="2" testid ="5869"> 
		///		<ExpectedInput>Valid business object data for detailed report</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="3" testid ="5870"> 
		///		<ExpectedInput>Valid business object data for multi divisional detailed report</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="4" testid ="5871"> 
		///		<ExpectedInput>Invalid business object data (start and end dates)</ExpectedInput>
		///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetReportData
		/// </summary>
		public DataSet GetReportData()
		{
			DataSet reportData = new DataSet("TransfusionReactionCountData");
			DataSet temp;
			//
			if (this.DetailedReport)
			{
				if(this.IsMultiDivisional)
				{
					temp =  DAL.TransfusionReactionReport.GetDetailedDataForReportAllDivisions(this.StartDate, this.EndDate);
				}
				else
				{
					temp = DAL.TransfusionReactionReport.GetDetailedDataForReport(this.StartDate, this.EndDate);
				}
			}
			else
			{
				if (this.IsMultiDivisional)
				{
					temp =  DAL.TransfusionReactionReport.GetSummaryDataForReportAllDivisions(this.StartDate, this.EndDate);
				}
				else
				{
					temp = DAL.TransfusionReactionReport.GetSummaryDataForReport(this.StartDate, this.EndDate);
				}
			}
			//
			DataTable newTable = new DataTable();
			newTable.TableName = "ReportInfo";
			newTable.Columns.Add(ARTIFICIAL.DetailReport, typeof(bool));
			newTable.Columns.Add(ARTIFICIAL.RecordCount, typeof(int));
			//
			DataRow newRow = newTable.NewRow();
			newRow[ARTIFICIAL.DetailReport] = this.DetailedReport;
			//
			if(temp.Tables.Count > 0 && temp.Tables[0].Rows.Count > 0)
			{
				newRow[ARTIFICIAL.RecordCount] = temp.Tables[0].Rows.Count;
			}
			else
			{
				newRow[ARTIFICIAL.RecordCount] = 0;
			}
			newTable.Rows.Add(newRow);
			reportData.Tables.Add(newTable);
			//
            temp.Tables[0].PrimaryKey = new DataColumn[0];
            temp.Tables[0].Columns[TABLE.PatientTransfusionReaction.TransfusionReactionTypeCode].Unique = false;
			if (this.DetailedReport)
			{
				DataTable dt = temp.Tables[0].Copy();
				dt.Columns.Add(TABLE.BloodUnitMedia.Comments, typeof(string));
				//
				for (int i = 0; i < dt.Rows.Count; i++)
				{
					for (int j = 0; j < temp.Tables[1].Rows.Count; j++)
					{
						if ( dt.Rows[i][TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid].ToString().Equals( temp.Tables[1].Rows[j][TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid].ToString() ) )
						{
							string currentComments = dt.Rows[i][TABLE.BloodUnitMedia.Comments].ToString();
							string newComment = temp.Tables[1].Rows[j][TABLE.PatientTransfusionComment.PatientTransfusionCommentText].ToString();
							//
							if( currentComments.Length == 0 )
							{
								dt.Rows[i][TABLE.BloodUnitMedia.Comments] = newComment;
							}
							else
							{
								dt.Rows[i][TABLE.BloodUnitMedia.Comments] = string.Concat( currentComments, "; ", newComment );
							}
						}

					}
				}
				//
				reportData.Tables.Add(dt);
			}
			else
			{
				DataTable dt = temp.Tables[0].Copy();
				reportData.Tables.Add(dt);
			}
			//
			return reportData;
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/22/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5863"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5864"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Builds report criteria string 
		/// (what subreports were included, etc.)
		/// </summary>
		public string GetReportCriteria()
		{
			StringBuilder builder = new StringBuilder();
			builder.Append("Start Date = ");
			builder.Append(Common.VBECSDateTime.FormatDateString(this.StartDate));
			builder.Append(", End Date = ");
			builder.Append(Common.VBECSDateTime.FormatDateString(this.EndDate));
			builder.Append(", Requested Report: ");
			builder.Append(this.DetailedReport ? "Detailed" : "Summary");
			builder.Append(this.IsMultiDivisional ? ", Multi Divisional" : ", Single Division");
			return builder.ToString();
		}

		#endregion
	}
}
